@echo off
setlocal enabledelayedexpansion

rem Check CLI availability
where ylm2 >nul 2>&1
if errorlevel 1 (
  echo Error: 'ylm2' not found in PATH. Install Youlean Loudness Meter 2 CLI or add it to PATH.
  pause
  exit /b 1
)

rem Get folder (arg or prompt)
set "FOLDER=%~1"
if "%FOLDER%"=="" (
  set /p FOLDER=Enter analysis folder path: 
)

rem --- Sanitize: remove ALL quotes the user might have typed (handles ...Samplerates""")
set "FOLDER=%FOLDER:"=%"

rem Normalize to a full absolute path
for %%I in ("%FOLDER%") do set "FOLDER=%%~fI"

rem Validate folder
if not exist "%FOLDER%\" (
  echo Error: Folder does not exist: "%FOLDER%"
  pause
  exit /b 1
)

rem Count files (recursive)
set /a TOTAL=0
for /r "%FOLDER%" %%F in (*.mp3 *.flac *.wav *.ogg) do (
  set /a TOTAL+=1
)

echo Found %TOTAL% audio file(s) in: "%FOLDER%"
if %TOTAL%==0 (
  pause
  exit /b 0
)

set /a processed=0
set /a failed=0

rem Analyze each file
for /r "%FOLDER%" %%F in (*.mp3 *.flac *.wav *.ogg) do (
  echo Analyzing: "%%~fF"
  ylm2 --input-file-path "%%~fF" --export --export-type "TEXT_SUMMARY"
  if errorlevel 1 (
    echo   -> Error analyzing file: "%%~fF"
    set /a failed+=1
  ) else (
    set /a processed+=1
  )
)

echo Done. Found %TOTAL% file(s); analyzed %processed%; failed %failed%.
pause
